/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.modules.sceGpio;
import jpcsp.hardware.Battery;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerGpio
extends MMIOHandlerBase {
    public static Logger log = sceGpio.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1104936960;
    private static MMIOHandlerGpio instance;
    public static final int GPIO_PORT_DISPLAY = 0;
    public static final int GPIO_PORT_WM8750_Port1 = 1;
    public static final int GPIO_PORT_SYSCON_START_CMD = 3;
    public static final int GPIO_PORT_SYSCON_END_CMD = 4;
    public static final int GPIO_PORT_WM8750_Port5 = 5;
    public static final int GPIO_PORT_LED_MS = 6;
    public static final int GPIO_PORT_LED_WLAN = 7;
    public static final int GPIO_PORT_USB = 23;
    public static final int GPIO_PORT_BLUETOOTH = 24;
    public static final int GPIO_PORT_UMD = 26;
    public static final int GPIO_PORT_SERVICE_BATTERY = 4;
    private static final int NUMBER_PORTS = 32;
    private int ports;
    private int isOutput;
    private int isInputOn;
    private int isInterruptEnabled;
    private int isInterruptTriggered;
    private int isEdgeDetection;
    private int isRisingEdge;
    private int isFallingEdge;
    private int isCapturePort;
    private int isTimerCaptureEnabled;

    public static MMIOHandlerGpio getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerGpio(-1104936960);
        }
        return instance;
    }

    private MMIOHandlerGpio(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.ports = stream.readInt();
        this.isOutput = stream.readInt();
        this.isInputOn = stream.readInt();
        this.isInterruptEnabled = stream.readInt();
        this.isInterruptTriggered = stream.readInt();
        this.isEdgeDetection = stream.readInt();
        this.isRisingEdge = stream.readInt();
        this.isFallingEdge = stream.readInt();
        this.isCapturePort = stream.readInt();
        this.isTimerCaptureEnabled = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.ports);
        stream.writeInt(this.isOutput);
        stream.writeInt(this.isInputOn);
        stream.writeInt(this.isInterruptEnabled);
        stream.writeInt(this.isInterruptTriggered);
        stream.writeInt(this.isEdgeDetection);
        stream.writeInt(this.isRisingEdge);
        stream.writeInt(this.isFallingEdge);
        stream.writeInt(this.isCapturePort);
        stream.writeInt(this.isTimerCaptureEnabled);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.ports = 0;
        this.isOutput = 0;
        this.isInputOn = 0;
        this.isInterruptEnabled = 0;
        this.isInterruptTriggered = 0;
        this.isEdgeDetection = 0;
        this.isRisingEdge = 0;
        this.isFallingEdge = 0;
        this.isCapturePort = 0;
        this.isTimerCaptureEnabled = 0;
        Battery.initialize();
        if (Battery.readEepromBatterySerialNumber() == -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Booting from a service battery", new Object[0]));
            }
            this.setPort(4);
        }
    }

    private static String getPortName(int port) {
        switch (port) {
            case 0: {
                return "DISPLAY";
            }
            case 1: {
                return "WM8750_Port1";
            }
            case 3: {
                return "SYSCON_START_CMD";
            }
            case 4: {
                return "SYSCON_END_CMD";
            }
            case 5: {
                return "WM8750_Port5";
            }
            case 6: {
                return "LED_MS";
            }
            case 7: {
                return "LED_WLAN";
            }
            case 23: {
                return "USB";
            }
            case 24: {
                return "BLUETOOTH";
            }
            case 26: {
                return "UMD";
            }
        }
        return String.format("GPIO_UNKNOWN_PORT_0x%X", port);
    }

    public void setPort(int port) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MMIOHandlerGpio.setPort 0x%X(%s) on %s", port, MMIOHandlerGpio.getPortName(port), this));
        }
        if (!Utilities.hasBit(this.ports, port)) {
            if (Utilities.hasBit(this.isRisingEdge, port)) {
                this.triggerInterrupt(port);
            }
            this.ports = Utilities.setBit(this.ports, port);
        }
    }

    public boolean readPort(int port) {
        return Utilities.hasBit(this.ports, port);
    }

    public void clearPort(int port) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MMIOHandlerGpio.clearPort 0x%X(%s) on %s", port, MMIOHandlerGpio.getPortName(port), this));
        }
        if (Utilities.hasBit(this.ports, port)) {
            if (Utilities.hasBit(this.isFallingEdge, port)) {
                this.triggerInterrupt(port);
            }
            this.ports = Utilities.clearBit(this.ports, port);
        }
    }

    private void triggerInterrupt(int bit) {
        if (!Utilities.hasBit(this.isInterruptTriggered, bit)) {
            this.isInterruptTriggered = Utilities.setBit(this.isInterruptTriggered, bit);
            this.checkInterrupt();
        }
    }

    private void checkInterrupt() {
        if ((this.isInterruptTriggered & this.isInterruptEnabled) != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 4);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 4);
        }
    }

    private void setPorts(int value) {
        if (value != 0) {
            for (int i = 0; i < 32; ++i) {
                if (!Utilities.hasBit(value, i)) continue;
                this.setPort(i);
            }
        }
    }

    private void clearPorts(int value) {
        if (value != 0) {
            for (int i = 0; i < 32; ++i) {
                if (!Utilities.hasBit(value, i)) continue;
                this.clearPort(i);
            }
        }
    }

    private void acknowledgeInterrupt(int value) {
        if (value != 0 && this.isInterruptTriggered != 0) {
            this.isInterruptTriggered &= ~value;
            this.checkInterrupt();
        }
    }

    private void setInterruptEnabled(int isInterruptEnabled) {
        if (this.isInterruptEnabled != isInterruptEnabled) {
            this.isInterruptEnabled = isInterruptEnabled;
            this.checkInterrupt();
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.isOutput;
                break;
            }
            case 4: {
                value = this.ports;
                break;
            }
            case 16: {
                value = this.isEdgeDetection;
                break;
            }
            case 20: {
                value = this.isFallingEdge;
                break;
            }
            case 24: {
                value = this.isRisingEdge;
                break;
            }
            case 28: {
                value = this.isInterruptEnabled;
                break;
            }
            case 32: {
                value = this.isInterruptTriggered;
                break;
            }
            case 48: {
                value = this.isCapturePort;
                break;
            }
            case 52: {
                value = this.isTimerCaptureEnabled;
                break;
            }
            case 64: {
                value = this.isInputOn;
                break;
            }
            case 72: {
                value = 0;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.isOutput = value;
                break;
            }
            case 8: {
                this.setPorts(value);
                break;
            }
            case 12: {
                this.clearPorts(value);
                break;
            }
            case 16: {
                this.isEdgeDetection = value;
                break;
            }
            case 20: {
                this.isFallingEdge = value;
                break;
            }
            case 24: {
                this.isRisingEdge = value;
                break;
            }
            case 28: {
                this.setInterruptEnabled(value);
                break;
            }
            case 36: {
                this.acknowledgeInterrupt(value);
                break;
            }
            case 48: {
                this.isCapturePort = value;
                break;
            }
            case 52: {
                this.isTimerCaptureEnabled = value;
                break;
            }
            case 64: {
                this.isInputOn = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    private static String getPortNames(int bits) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            if (!Utilities.hasBit(bits, i)) continue;
            if (s.length() > 0) {
                s.append("|");
            }
            s.append(MMIOHandlerGpio.getPortName(i));
        }
        return s.toString();
    }

    @Override
    public String toString() {
        return String.format("MMIOHandlerGpio ports=0x%08X(%s), isInterruptEnabled=0x%08X(%s), isInterruptTriggered=0x%08X(%s), isOutput=0x%08X(%s), isEdgeDetection=0x%08X, isFallingEdge=0x%08X, isRisingEdge=0x%08X, isInputOn=0x%08X(%s)", this.ports, MMIOHandlerGpio.getPortNames(this.ports), this.isInterruptEnabled, MMIOHandlerGpio.getPortNames(this.isInterruptEnabled), this.isInterruptTriggered, MMIOHandlerGpio.getPortNames(this.isInterruptTriggered), this.isOutput, MMIOHandlerGpio.getPortNames(this.isOutput), this.isEdgeDetection, this.isFallingEdge, this.isRisingEdge, this.isInputOn, MMIOHandlerGpio.getPortNames(this.isInputOn));
    }
}

